/*
 * Decompiled with CFR 0.152.
 */
package com.quantumdata.cec;

import com.quantumdata.cec.CECComplianceCDF;
import com.quantumdata.cec.CECComplianceMain;
import com.quantumdata.std.xml.DbNode;
import com.quantumdata.widgets.QDButton;
import com.quantumdata.widgets.QDCheckBox;
import com.quantumdata.widgets.QDLabel;
import com.quantumdata.widgets.QDPanel;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Scanner;
import javax.swing.JComboBox;
import javax.swing.JOptionPane;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;

public class CECComplianceCDFGeneral
extends QDPanel
implements ActionListener {
    private QDCheckBox[] devTypeBoxes;
    private QDCheckBox rootDevice;
    private QDCheckBox cecSignalsIndependent;
    private QDCheckBox cecEnablingSetting;
    private QDCheckBox selectSrcViaMenu;
    private JComboBox numInputs;
    private JComboBox numOutputs;
    private JComboBox cecCapableOutput;
    private JComboBox numCecLines;
    private JTextField makeName;
    private JTextField modelName;
    private JTextField cdfDescription;
    private QDButton loadBtn;
    private QDButton csvLoadBtn;
    private QDButton saveBtn;
    private QDButton useBtn;
    private JComboBox testDev;
    private CECComplianceCDF m_parent;

    public CECComplianceCDFGeneral(CECComplianceCDF cECComplianceCDF) {
        int n;
        this.m_parent = cECComplianceCDF;
        Dimension dimension = new Dimension(150, 35);
        this.loadBtn = new QDButton("Load CDF");
        this.loadBtn.setPreferredSize(dimension);
        this.loadBtn.addActionListener(this);
        this.loadBtn.setToolTipText("Load a CDF from the 882.");
        this.csvLoadBtn = new QDButton("Load Excel CSV");
        this.csvLoadBtn.setPreferredSize(dimension);
        this.csvLoadBtn.addActionListener(this);
        this.csvLoadBtn.setToolTipText("Load a part of a CDF from an Excel CSV-format file.");
        this.saveBtn = new QDButton("Save CDF");
        this.saveBtn.setPreferredSize(dimension);
        this.saveBtn.addActionListener(this);
        this.saveBtn.setToolTipText("Save the current CDF to the 882.");
        this.useBtn = new QDButton("Use CDF");
        this.useBtn.setPreferredSize(dimension);
        this.useBtn.addActionListener(this);
        this.useBtn.setToolTipText("Use the last loaded or saved CDF.");
        this.testDev = new JComboBox();
        for (int i = 0; i < 6; ++i) {
            this.testDev.addItem(CECComplianceCDF.deviceTypeNamesAlt[i]);
        }
        this.devTypeBoxes = new QDCheckBox[6];
        GridBagLayout gridBagLayout = new GridBagLayout();
        this.setLayout(gridBagLayout);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(6, 6, 6, 6);
        QDPanel qDPanel = new QDPanel(new BorderLayout());
        QDPanel qDPanel2 = new QDPanel(gridBagLayout);
        QDPanel qDPanel3 = new QDPanel(gridBagLayout);
        QDPanel qDPanel4 = new QDPanel(gridBagLayout);
        QDPanel qDPanel5 = new QDPanel(gridBagLayout);
        TitledBorder titledBorder = new TitledBorder("Help");
        titledBorder.setTitleJustification(2);
        titledBorder.setTitleColor(Color.WHITE);
        qDPanel4.setBorder(titledBorder);
        titledBorder = new TitledBorder("CDF Tools");
        titledBorder.setTitleJustification(2);
        titledBorder.setTitleColor(Color.WHITE);
        qDPanel.setBorder(titledBorder);
        titledBorder = new TitledBorder("Product CDF Entries");
        titledBorder.setTitleJustification(2);
        titledBorder.setTitleColor(Color.WHITE);
        qDPanel3.setBorder(titledBorder);
        titledBorder = new TitledBorder("Device type to test:");
        titledBorder.setTitleJustification(2);
        titledBorder.setTitleColor(Color.WHITE);
        qDPanel5.setBorder(titledBorder);
        qDPanel5.add((Component)this.testDev, gridBagConstraints);
        qDPanel4.add((Component)new QDLabel("<HTML>Set up your general CDF first.<p>Your general CDF should describe<br>which devices you support.<p>Your device selection determines<br>which tabs are available to you.</HTML>"), gridBagConstraints);
        qDPanel.add((Component)this.csvLoadBtn, "Before");
        qDPanel.add((Component)this.saveBtn, "First");
        qDPanel.add((Component)this.loadBtn, "After");
        qDPanel.add((Component)this.useBtn, "Last");
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        qDPanel2.add((Component)qDPanel, gridBagConstraints);
        gridBagConstraints.gridy = 1;
        qDPanel2.add((Component)qDPanel5, gridBagConstraints);
        gridBagConstraints.gridy = 2;
        qDPanel2.add((Component)qDPanel4, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.anchor = 11;
        this.add((Component)qDPanel2, gridBagConstraints);
        gridBagConstraints.anchor = 17;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        qDPanel3.add((Component)new QDLabel("Maker"), gridBagConstraints);
        gridBagConstraints.gridy = 3;
        qDPanel3.add((Component)new QDLabel("Model Name"), gridBagConstraints);
        gridBagConstraints.gridy = 4;
        gridBagConstraints.insets.bottom = 25;
        qDPanel3.add((Component)new QDLabel("CDF Description"), gridBagConstraints);
        gridBagConstraints.insets.bottom = 4;
        gridBagConstraints.gridy = 9;
        gridBagConstraints.gridheight = 6;
        gridBagConstraints.anchor = 17;
        qDPanel3.add((Component)new QDLabel("CEC Device Types"), gridBagConstraints);
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.gridy = 15;
        qDPanel3.add((Component)new QDLabel("<HTML>Device acts as a Root Device<br>(Meaning: DUT is a Sink or Repeater<br>and DUT's Physical Address is<br>0.0.0.0 and DUT's EDID(s) [if present]<br>contain Source PA of P.0.0.0)</HTML>"), gridBagConstraints);
        gridBagConstraints.gridy = 16;
        qDPanel3.add((Component)new QDLabel("Number of HDMI Inputs"), gridBagConstraints);
        gridBagConstraints.gridy = 17;
        qDPanel3.add((Component)new QDLabel("<HTML>CEC signals on the input<br>connectors are independent<br>(Meaning: no physical connection<br>between inputs and DUT has<br>a logical address of 0 for all inputs.)<br>[Note: If device has no HDMI<br>inputs, answer \"N\".]</HTML>"), gridBagConstraints);
        gridBagConstraints.gridy = 18;
        qDPanel3.add((Component)new QDLabel("Number of HDMI Outputs"), gridBagConstraints);
        gridBagConstraints.gridy = 19;
        qDPanel3.add((Component)new QDLabel("Port # of the CEC-capable output"), gridBagConstraints);
        gridBagConstraints.gridy = 20;
        qDPanel3.add((Component)new QDLabel("<HTML>Number of independent CEC lines in<br>the product, driven by independent CEC<br>driving circuitry and logical<br>processing</HTML>"), gridBagConstraints);
        gridBagConstraints.gridy = 21;
        qDPanel3.add((Component)new QDLabel("CEC enabling initial setting exists"), gridBagConstraints);
        gridBagConstraints.gridy = 22;
        qDPanel3.add((Component)new QDLabel("DUT allows selecting source via menu"), gridBagConstraints);
        gridBagConstraints.insets = new Insets(1, 6, 1, 2);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.gridy = 9;
        gridBagConstraints.insets = new Insets(1, 2, 1, 2);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridwidth = 3;
        this.makeName = new JTextField();
        this.modelName = new JTextField();
        this.cdfDescription = new JTextField();
        this.makeName.setColumns(16);
        this.modelName.setColumns(16);
        this.cdfDescription.setColumns(16);
        gridBagConstraints.gridy = 2;
        qDPanel3.add((Component)this.makeName, gridBagConstraints);
        gridBagConstraints.gridy = 3;
        qDPanel3.add((Component)this.modelName, gridBagConstraints);
        gridBagConstraints.gridy = 4;
        gridBagConstraints.insets.bottom = 25;
        qDPanel3.add((Component)this.cdfDescription, gridBagConstraints);
        gridBagConstraints.insets.bottom = 4;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 9;
        for (n = 0; n < 6; ++n) {
            this.devTypeBoxes[n] = new QDCheckBox(CECComplianceCDF.deviceTypeNamesAlt[n]);
            this.devTypeBoxes[n].setHorizontalTextPosition(10);
            this.devTypeBoxes[n].addActionListener(this);
            this.devTypeBoxes[n].setFont(CECComplianceMain.m_checkBoxFont);
            this.devTypeBoxes[n].setToolTipText("Select these to allow adding the CDF for this device.");
            qDPanel3.add((Component)this.devTypeBoxes[n], gridBagConstraints);
            ++gridBagConstraints.gridy;
        }
        this.rootDevice = new QDCheckBox();
        qDPanel3.add((Component)this.rootDevice, gridBagConstraints);
        ++gridBagConstraints.gridy;
        this.numInputs = new JComboBox();
        this.numOutputs = new JComboBox();
        this.cecCapableOutput = new JComboBox();
        this.numCecLines = new JComboBox();
        for (n = 0; n < 9; ++n) {
            this.numInputs.addItem("" + n);
            this.numOutputs.addItem("" + n);
            this.cecCapableOutput.addItem("" + n);
            if (n >= 8) continue;
            this.numCecLines.addItem("" + (n + 1));
        }
        qDPanel3.add((Component)this.numInputs, gridBagConstraints);
        ++gridBagConstraints.gridy;
        this.cecSignalsIndependent = new QDCheckBox();
        qDPanel3.add((Component)this.cecSignalsIndependent, gridBagConstraints);
        ++gridBagConstraints.gridy;
        qDPanel3.add((Component)this.numOutputs, gridBagConstraints);
        ++gridBagConstraints.gridy;
        qDPanel3.add((Component)this.cecCapableOutput, gridBagConstraints);
        ++gridBagConstraints.gridy;
        qDPanel3.add((Component)this.numCecLines, gridBagConstraints);
        ++gridBagConstraints.gridy;
        this.cecEnablingSetting = new QDCheckBox();
        qDPanel3.add((Component)this.cecEnablingSetting, gridBagConstraints);
        ++gridBagConstraints.gridy;
        this.selectSrcViaMenu = new QDCheckBox();
        qDPanel3.add((Component)this.selectSrcViaMenu, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        this.add((Component)qDPanel3, gridBagConstraints);
    }

    public boolean SendCDFEntries(DbNode dbNode) {
        int n = 0;
        for (int i = 0; i < this.devTypeBoxes.length; ++i) {
            if (this.devTypeBoxes[i].isSelected()) {
                dbNode.addElement("SupportedDev", i);
            }
            ++n;
        }
        dbNode.addElement("Make", this.makeName.getText());
        dbNode.addElement("Model", this.modelName.getText());
        dbNode.addElement("CDFDescription", this.cdfDescription.getText());
        dbNode.addElement("RootDev", this.rootDevice.isSelected());
        dbNode.addElement("IndependentSignals", this.cecSignalsIndependent.isSelected());
        dbNode.addElement("EnablingSetting", this.cecEnablingSetting.isSelected());
        dbNode.addElement("NumInputs", this.numInputs.getSelectedIndex());
        dbNode.addElement("NumOutputs", this.numOutputs.getSelectedIndex());
        dbNode.addElement("CECOutput", this.cecCapableOutput.getSelectedIndex());
        dbNode.addElement("NumCECLines", this.numCecLines.getSelectedIndex() + 1);
        dbNode.addElement("SrcSelectMenu", this.selectSrcViaMenu.isSelected());
        return n > 0;
    }

    public void GetCDFEntries(DbNode dbNode) {
        int n;
        boolean bl = false;
        for (n = 0; n < this.devTypeBoxes.length; ++n) {
            this.devTypeBoxes[n].setSelected(false);
            this.m_parent.EnableTab(n, false);
        }
        for (n = 0; n < dbNode.getNodeCount(); ++n) {
            DbNode dbNode2 = dbNode.getNode(n);
            if (dbNode2.getName() != "SupportedDev") continue;
            int n2 = dbNode2.getIntValue();
            this.devTypeBoxes[n2].setSelected(true);
            this.m_parent.EnableTab(n2, true);
            if (bl) continue;
            this.testDev.setSelectedIndex(n2);
            bl = true;
        }
        this.makeName.setText(dbNode.getElement("Make"));
        this.modelName.setText(dbNode.getElement("Model"));
        this.cdfDescription.setText(dbNode.getElement("CDFDescription"));
        this.rootDevice.setSelected(dbNode.getBoolElement("RootDev"));
        this.cecSignalsIndependent.setSelected(dbNode.getBoolElement("IndependentSignals"));
        this.cecEnablingSetting.setSelected(dbNode.getBoolElement("EnablingSetting"));
        this.numInputs.setSelectedIndex(dbNode.getIntElement("NumInputs"));
        this.numOutputs.setSelectedIndex(dbNode.getIntElement("NumOutputs"));
        this.cecCapableOutput.setSelectedIndex(dbNode.getIntElement("CECOutput"));
        this.numCecLines.setSelectedIndex(dbNode.getIntElement("NumCECLines") - 1);
        this.selectSrcViaMenu.setSelected(dbNode.getBoolElement("SrcSelectMenu"));
    }

    public void actionPerformed(ActionEvent actionEvent) {
        for (int i = 0; i < this.devTypeBoxes.length; ++i) {
            if (actionEvent.getSource() != this.devTypeBoxes[i]) continue;
            this.m_parent.EnableTab(i, this.devTypeBoxes[i].isSelected());
        }
        if (actionEvent.getSource() == this.loadBtn) {
            this.m_parent.LoadCDF();
        }
        if (actionEvent.getSource() == this.saveBtn) {
            this.m_parent.SaveCDF();
        }
        if (actionEvent.getSource() == this.useBtn) {
            if (!this.devTypeBoxes[this.testDev.getSelectedIndex()].isSelected()) {
                JOptionPane.showMessageDialog(this, "<HTML>Your current 'Device type to test' selection<br>does not match any device type described<br>in your current CDF.</HTML>");
            } else {
                this.m_parent.UseCDF(this.testDev.getSelectedIndex());
            }
        }
        if (actionEvent.getSource() == this.csvLoadBtn) {
            this.m_parent.LoadCDFFromCSV();
        }
    }

    public void LoadFromCSV(Scanner scanner) {
        try {
            String[] stringArray;
            int n;
            for (n = 0; n < 11; ++n) {
                scanner.nextLine();
            }
            n = 0;
            for (int i = 0; i < 6; ++i) {
                stringArray = scanner.nextLine().split(",");
                this.SetCheckbox(stringArray, 3, this.devTypeBoxes[i]);
                this.m_parent.EnableTab(i, this.devTypeBoxes[i].isSelected());
                if (!this.devTypeBoxes[i].isSelected() || n != 0) continue;
                this.testDev.setSelectedIndex(i);
                n = 1;
            }
            scanner.nextLine();
            stringArray = scanner.nextLine().split(",");
            this.SetCheckbox(stringArray, 3, this.rootDevice);
            stringArray = scanner.nextLine().split(",");
            this.SetIndex(stringArray, 3, this.numInputs);
            scanner.nextLine();
            stringArray = scanner.nextLine().split(",");
            this.SetCheckbox(stringArray, 3, this.cecSignalsIndependent);
            stringArray = scanner.nextLine().split(",");
            this.SetIndex(stringArray, 3, this.numOutputs);
            stringArray = scanner.nextLine().split(",");
            this.SetIndex(stringArray, 3, this.cecCapableOutput);
            stringArray = scanner.nextLine().split(",");
            this.SetIndex(stringArray, 3, this.numCecLines);
            scanner.nextLine();
            scanner.nextLine();
            stringArray = scanner.nextLine().split(",");
            this.SetCheckbox(stringArray, 3, this.cecEnablingSetting);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            scanner.close();
            return;
        }
    }

    private void SetCheckbox(String[] stringArray, int n, QDCheckBox qDCheckBox) {
        boolean bl = false;
        if (stringArray.length > n && stringArray[n].length() > 0 && stringArray[n].toUpperCase().charAt(0) == 'Y') {
            bl = true;
        }
        qDCheckBox.setSelected(bl);
    }

    private void SetIndex(String[] stringArray, int n, JComboBox jComboBox) {
        if (stringArray.length > n && stringArray[n].length() > 0) {
            try {
                jComboBox.setSelectedIndex(Integer.parseInt(stringArray[n]));
            }
            catch (Exception exception) {
                JOptionPane.showMessageDialog(this, "Parse error: " + stringArray[n] + " is not a number.", "Error!", 0);
            }
        }
    }

    public int GetNumOfDevs() {
        int n = 0;
        for (int i = 0; i < this.devTypeBoxes.length; ++i) {
            if (!this.devTypeBoxes[i].isSelected()) continue;
            ++n;
        }
        return n;
    }

    public int GetFirstEnabledDev() {
        for (int i = 0; i < this.devTypeBoxes.length; ++i) {
            if (!this.devTypeBoxes[i].isSelected()) continue;
            return i;
        }
        return -1;
    }

    public QDCheckBox[] GetDevBoxes() {
        return this.devTypeBoxes;
    }
}

